using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
	public partial class DOD_FRAGMENT_LABDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public DOD_FRAGMENT_LABDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public BO.DOD_FRAGMENT_LAB GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 DOD_FRAGMENT_LAB_ID)
		{
            BO.DOD_FRAGMENT_LAB objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_DOD_FRAGMENT_LAB_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, DOD_FRAGMENT_LAB_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<BO.DOD_FRAGMENT_LAB> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<BO.DOD_FRAGMENT_LAB> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_DOD_FRAGMENT_LAB_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, BO.DOD_FRAGMENT_LAB objSave)
		{
			Int32? objReturn = objSave.DOD_FRAGMENT_LAB_ID;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_DOD_FRAGMENT_LAB_save(CURRENT_USER, CURRENT_REGISTRY_ID, DateTime.Now, objSave.CREATEDBY, ref objReturn, objSave.LAB_ACCESSION_NUMBER, objSave.LAB_CODE, objSave.LAB_ID, objSave.LAB_NAME, objSave.LAB_REPORT_DATE, objSave.PATIENT_ID, objSave.PRODUCING_EVENT_DATE, DateTime.Now, objSave.UPDATEDBY);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 DOD_FRAGMENT_LAB_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_DOD_FRAGMENT_LAB_delete(CURRENT_USER, CURRENT_REGISTRY_ID, DOD_FRAGMENT_LAB_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
